/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch.token;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import redempt.crunch.token.Token;
import redempt.crunch.token.TokenType;

public enum Operator implements Token
{
    BOOLEAN_OR("|", 0, (a, b) -> a == 1.0 || b == 1.0 ? 1.0 : 0.0),
    BOOLEAN_AND("&", 0, (a, b) -> a == 1.0 && b == 1.0 ? 1.0 : 0.0),
    GREATER_THAN(">", 1, (a, b) -> a > b ? 1.0 : 0.0),
    LESS_THAN("<", 1, (a, b) -> a < b ? 1.0 : 0.0),
    EQUAL_TO("=", 1, (a, b) -> a == b ? 1.0 : 0.0),
    EQUAL_TO_ALT("==", 1, (a, b) -> a == b ? 1.0 : 0.0),
    NOT_EQUAL_TO("!=", 1, (a, b) -> a != b ? 1.0 : 0.0),
    GREATER_THAN_OR_EQUAL_TO(">=", 1, (a, b) -> a >= b ? 1.0 : 0.0),
    LESS_THAN_OR_EQUAL_TO("<=", 1, (a, b) -> a <= b ? 1.0 : 0.0),
    BOOLEAN_NOT("!", 9, d -> d == 0.0 ? 1.0 : 0.0),
    RANDOM_DOUBLE("rand", 6, d -> ThreadLocalRandom.current().nextDouble() * d),
    ROUND("round", 6, d -> Math.round(d)),
    CEILING("ceil", 6, d -> Math.ceil(d)),
    FLOOR("floor", 6, d -> Math.floor(d)),
    ARC_SINE("asin", 6, d -> Math.asin(d)),
    ARC_COSINE("acos", 6, d -> Math.acos(d)),
    ARC_TANGENT("atan", 6, d -> Math.atan(d)),
    SINE("sin", 6, d -> Math.sin(d)),
    COSINE("cos", 6, d -> Math.cos(d)),
    TANGENT("tan", 6, d -> Math.tan(d)),
    HYPERBOLIC_SINE("sinh", 6, d -> Math.sinh(d)),
    HYPERBOLIC_COSINE("cosh", 6, d -> Math.cosh(d)),
    HYPERBOLIC_TANGENT("tanh", 6, d -> Math.tanh(d)),
    ABSOLUTE_VALUE("abs", 6, d -> Math.abs(d)),
    LOGARITHM("log", 6, d -> Math.log(d)),
    SQUARE_ROOT("sqrt", 6, d -> Math.sqrt(d)),
    CUBE_ROOT("cbrt", 6, d -> Math.cbrt(d)),
    EXPONENT("^", 5, (a, b) -> Math.pow(a, b)),
    MULTIPLY("*", 4, (a, b) -> a * b),
    DIVIDE("/", 4, (a, b) -> a / b),
    MODULUS("%", 4, (a, b) -> a % b),
    ADD("+", 3, (a, b) -> a + b),
    SUBTRACT("-", 3, (a, b) -> a - b),
    NEGATE("-", 10, d -> -d, true);

    private String name;
    private boolean unary;
    private DoubleBinaryOperator operate;
    private int priority;
    private boolean internal;

    private Operator(String name, int priority, DoubleBinaryOperator operate) {
        this(name, priority, operate, false);
    }

    private Operator(String name, int priority, DoubleBinaryOperator operate, boolean internal) {
        this.name = name;
        this.operate = operate;
        this.unary = false;
        this.priority = priority;
        this.internal = internal;
    }

    private Operator(String name, int priority, DoubleUnaryOperator operate) {
        this(name, priority, operate, false);
    }

    private Operator(String name, int priority, DoubleUnaryOperator operate, boolean internal) {
        this.name = name;
        this.operate = (a, b) -> operate.applyAsDouble(a);
        this.unary = true;
        this.priority = priority;
        this.internal = internal;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getSymbol() {
        return this.name;
    }

    public boolean isUnary() {
        return this.unary;
    }

    public double operate(double first, double second) {
        return this.operate.applyAsDouble(first, second);
    }

    public double operate(double value) {
        return this.operate.applyAsDouble(value, 0.0);
    }

    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public TokenType getType() {
        return TokenType.OPERATOR;
    }

    public String toString() {
        return this.getSymbol();
    }
}

