/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch.functional;

import java.util.Locale;
import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleFunction;
import redempt.crunch.Variable;
import redempt.crunch.data.CharTree;
import redempt.crunch.functional.Function;
import redempt.crunch.token.Constant;
import redempt.crunch.token.LazyVariable;
import redempt.crunch.token.Operator;
import redempt.crunch.token.Token;

public class EvaluationEnvironment {
    private CharTree<Token> namedTokens = new CharTree();

    public EvaluationEnvironment() {
        for (Operator operator : Operator.values()) {
            if (operator.isInternal()) continue;
            this.namedTokens.set(operator.getSymbol(), operator);
        }
        for (Enum enum_ : Constant.values()) {
            this.namedTokens.set(((Constant)enum_).toString().toLowerCase(Locale.ROOT), (Token)((Object)enum_));
        }
    }

    public void addFunction(Function function) {
        char[] chars;
        for (char c : chars = function.getName().toCharArray()) {
            if (c <= '\u00ff') continue;
            throw new IllegalArgumentException("Function names must be ASCII only");
        }
        this.namedTokens.set(function.getName(), function);
    }

    public void addFunctions(Function ... functions) {
        for (Function function : functions) {
            this.addFunction(function);
        }
    }

    public void addLazyVariable(String name, DoubleSupplier supply) {
        this.namedTokens.set(name, new LazyVariable(name, supply));
    }

    public void setVariableNames(String ... names) {
        for (int i = 0; i < names.length; ++i) {
            this.namedTokens.set(names[i], new Variable(null, i));
        }
    }

    public void addFunction(String name, int argCount, ToDoubleFunction<double[]> func) {
        this.addFunction(new Function(name, argCount, func));
    }

    public void clearFunctions() {
        this.namedTokens = new CharTree();
    }

    public CharTree<Token> getNamedTokens() {
        return this.namedTokens;
    }
}

