/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch;

import redempt.crunch.Variable;
import redempt.crunch.exceptions.ExpressionEvaluationException;
import redempt.crunch.token.Operation;
import redempt.crunch.token.TokenType;
import redempt.crunch.token.Value;

public class CompiledExpression {
    protected double[] variableValues;
    private int variableCount;
    private Value value;

    protected CompiledExpression() {
    }

    protected void setVariableValues(double[] values) {
        this.checkArgCount(values.length);
        this.variableValues = values;
    }

    protected void setValue(Value value) {
        this.value = value;
        this.variableCount = this.recursiveVariableMaxIndex(value) + 1;
    }

    private int recursiveVariableMaxIndex(Value value) {
        if (value.getType() == TokenType.VARIABLE) {
            Variable var = (Variable)value;
            var.expression = this;
            return var.getIndex();
        }
        if (value.getType() != TokenType.OPERATION) {
            return -1;
        }
        int count = -1;
        Operation operation = (Operation)value;
        for (Value val : operation.getValues()) {
            if (val.getType() == TokenType.VARIABLE) {
                Variable var = (Variable)val;
                var.expression = this;
                count = Math.max(count, var.getIndex());
            }
            if (val.getType() != TokenType.OPERATION) continue;
            count = Math.max(count, this.recursiveVariableMaxIndex(val));
        }
        return count;
    }

    protected Value getValue() {
        return this.value;
    }

    public int getVariableCount() {
        return this.variableCount;
    }

    public double evaluate(double ... values) {
        this.setVariableValues(values);
        return this.value.getValue();
    }

    public double evaluate() {
        this.checkArgCount(0);
        return this.value.getValue();
    }

    public double evaluate(double first) {
        this.checkArgCount(1);
        if (this.variableValues == null) {
            this.variableValues = new double[1];
        }
        this.variableValues[0] = first;
        return this.value.getValue();
    }

    public double evaluate(double first, double second) {
        this.checkArgCount(2);
        if (this.variableValues == null) {
            this.variableValues = new double[2];
        }
        this.variableValues[0] = first;
        this.variableValues[1] = second;
        return this.value.getValue();
    }

    private void checkArgCount(int args) {
        if (this.variableCount > args) {
            throw new ExpressionEvaluationException("Too few variable values - expected " + this.variableCount + ", got " + args);
        }
    }

    public CompiledExpression clone() {
        CompiledExpression clone = new CompiledExpression();
        Value cloned = this.value.getClone();
        clone.setValue(cloned);
        return clone;
    }

    public String toString() {
        return this.value.toString();
    }
}

