/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch.token;

import redempt.crunch.token.Operator;
import redempt.crunch.token.TokenType;
import redempt.crunch.token.Value;

public class Operation
implements Value {
    private Operator operator;
    private Value first;
    private Value second;

    public Operation(Operator operator, Value value) {
        this.operator = operator;
        this.first = value;
    }

    public Operation(Operator operator, Value first, Value second) {
        this.operator = operator;
        this.first = first;
        this.second = second;
    }

    public Value[] getValues() {
        Value[] valueArray;
        if (this.operator.isUnary()) {
            Value[] valueArray2 = new Value[1];
            valueArray = valueArray2;
            valueArray2[0] = this.first;
        } else {
            Value[] valueArray3 = new Value[2];
            valueArray3[0] = this.first;
            valueArray = valueArray3;
            valueArray3[1] = this.second;
        }
        return valueArray;
    }

    @Override
    public double getValue() {
        return this.operator.isUnary() ? this.operator.operate(this.first.getValue()) : this.operator.operate(this.first.getValue(), this.second.getValue());
    }

    @Override
    public TokenType getType() {
        return TokenType.OPERATION;
    }

    public String toString() {
        return "(" + (this.operator.isUnary() ? this.operator.getSymbol() + this.first.toString() : this.first.toString() + this.operator.getSymbol() + this.second.toString()) + ")";
    }

    @Override
    public Operation getClone() {
        return this.operator.isUnary() ? new Operation(this.operator, this.first.getClone()) : new Operation(this.operator, this.first.getClone(), this.second.getClone());
    }
}

